package gov.va.med.mhv.admin.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.FacilityInfoDTO;
import gov.va.med.mhv.common.data.model.FacilityInfo;


@Component
public class FacilityInfoConverter {

	public static FacilityInfoDTO convert(FacilityInfo facilityInfo) {

		FacilityInfoDTO dto = new FacilityInfoDTO();
		dto.setDomainName(facilityInfo.getDomainName());
		dto.setActive(facilityInfo.getActive());
		dto.setId(facilityInfo.getId());
		// dto.setIpAddress(facilityInfo.getIpAddress());
		dto.setName(facilityInfo.getName());
		dto.setOplock(facilityInfo.getOplock());
		dto.setPort(facilityInfo.getPort());
		dto.setStationNumber(facilityInfo.getStationNumber());
		// dto.setTimeOut(facilityInfo.getTimeOut());
		dto.setTreatment(facilityInfo.getTreatment());
		return dto;
	}

	public static FacilityInfo convertToDomain(FacilityInfoDTO facilityInfo) {

		FacilityInfo dto = new FacilityInfo();
		dto.setDomainName(facilityInfo.getDomainName());
		dto.setActive(facilityInfo.getActive());
		dto.setId(facilityInfo.getId());
		// dto.setIpAddress(facilityInfo.getIpAddress());
		dto.setName(facilityInfo.getName());
		dto.setOplock(facilityInfo.getOplock());
		dto.setPort(facilityInfo.getPort());
		dto.setStationNumber(facilityInfo.getStationNumber());
		// dto.setTimeOut(facilityInfo.getTimeOut());
		dto.setTreatment(facilityInfo.getTreatment());
		return dto;
	}

	public static List<FacilityInfoDTO> convertList(List<FacilityInfo> source) {

		List<FacilityInfoDTO> destination = new ArrayList<FacilityInfoDTO>();
		for (FacilityInfo a : source) {
			destination.add(convert(a));
		}
		return destination;
	}

}
